define(function () {

    var component = {
        inject: ["configuration"]
    };

    component.originalTemplate = "corpViewModern.card";
    component.template = `
<wizdomWebpart data-v-8163853a
  :environmentInfo="environmentInfo"
  :chromeProperties="webpartProperties.chromeProperties"
  :title="'Corporate News' | translate"
  @titleChanged="webpartProperties.title = $event"
  @webpart-resize="webpartResize"
>
  <div data-v-8163853a class="image ms-Grid revert-Padding" v-if="items[0]">
    <a data-v-8163853a :href="items[0].path" target="_blank" class="image-link">
      <div data-v-8163853a class="image-container ms-Grid-row" :style="getStyle(items[0])">
        <div data-v-8163853a
          v-if="items[0].breaking && webpartProperties.breakingTag"
          class="breaking"
        >{{webpartProperties.breakingTagText}}</div>
      </div>
    </a>
    <div data-v-8163853a class="ms-Grid-row">
      <a data-v-8163853a class="link" target="_blank" :href="items[0].path">
        <div data-v-8163853a id="content" class="content ms-Grid-col ms-sm12">
          <tags data-v-8163853a
            v-if="items[0].listOfTags"
            :tags="items[0].listOfTags"
            :sizenow="sizenow"
            ref="tags"
          ></tags>
          <h2 data-v-8163853a class="title">{{items[0].title}}</h2>
          <p data-v-8163853a
            class="content-text"
            v-html="(items[0].summary.length > 0 ? (items[0].summary.length > 75 ? items[0].summary.substring(0,75) : items[0].summary) : (items[0].content.length > 75 ? items[0].content.substring(0, 75) + '...' : items[0].content))"
          ></p>
          <div data-v-8163853a class="timeago-view-container">
            <div data-v-8163853a v-show="items[0].date" class="datetime">
              <uiIconClock data-v-8163853a />
              <timeago data-v-8163853a :since="items[0].date" locale="lang">></timeago>
            </div>
            <views data-v-8163853a v-if="webpartProperties.showViewCount" :views="items[0].views" class="views"></views>
          </div>
        </div>
      </a>
    </div>
  </div>
  <noItem data-v-8163853a
    v-if="!items.length && webpartProperties.contentPlaceholder"
    :title="contentPlaceholder.title"
    :theme="false"
    :illustration="'coffee'"
  ></noItem>
</wizdomWebpart>
`;
    component.styles = `
.breaking[data-v-8163853a] {
  color: "[theme:white, default:#fff]";
  background-color: "[theme:accent, default:#0078d4]";
  position: absolute;
  top: 20px;
  left: 0;
  z-index: 1;
  text-align: center;
  padding: 5px 10px 5px 10px;
}
.link[data-v-8163853a] {
  color: "[theme:bodyText, default: #333]";
  text-decoration: none;
}
.datetime[data-v-8163853a] {
  float: left;
  padding-right: 15px;
}
.container[data-v-8163853a] {
  max-height: 410px;
  width: 100%;
}
.views[data-v-8163853a] {
  font-size: 14px;
}
.image-container[data-v-8163853a] {
  position: relative;
  height: 130px;
  background-color: "[theme:neutralLighterAlt, default:#eaeaea]";
  border: 1px solid "[theme:neutralLight, default:#eaeaea]";
}
.content[data-v-8163853a] {
  max-height: 310px;
  position: relative;
  bottom: 0;
  padding-top: 20px;
  padding-bottom: 15px;
  padding-left: 24px;
  padding-right: 24px;
  color: "[theme:bodyText, default:#333]";
  overflow: hidden;
}
h2[data-v-8163853a] {
  font-size: 21px;
  color: "[theme:bodyText, default:#333]";
}
h2.title[data-v-8163853a] {
    margin: 0;
    display: block;
    font-weight: normal;
    line-height: 1.2;
    padding-top: 5px;
}
.content-text[data-v-8163853a] {
  font-size: 14px;
  padding-bottom: 20px;
  margin-top: 5px;
}
.image[data-v-8163853a] {
  align-self: flex-start;
  box-sizing: border-box;
  -ms-flex-negative: 0;
  flex-shrink: 0;
}


`;

    return component;

});
